from random import randint


def get_neighbours(val):
    x, y = val
    return (x + 1, y), (x - 1, y), (x, y + 1), (x, y - 1), (x + 1, y + 1), (x - 1, y + 1), (x - 1, y + 1), (x + 1, y - 1)


t, n = map(int, input().split())


MIN = -10 ** 9
MAX = 10 ** 9

for _ in range(t):
    i = 0
    while True:
        i += 1000000
        start = (i, i)
        stack = [start]
        visited = {start}

        print(f'? {start[0]} {start[1]}')
        current_color = input()
        if current_color == "0":
            exit(0)

        result = [start]

        while len(result) < n and stack:
            current = stack.pop()

            for neigh in get_neighbours(current):
                if neigh in visited:
                    continue

                visited.add(neigh)

                print(f'? {neigh[0]} {neigh[1]}')
                color = input()
                if color == "0":
                    exit(0)

                if color == current_color:
                    result.append(neigh)
                    stack.append(neigh)

                    if len(result) >= n:
                        break

        if len(result) < n:
            continue

        print('!', current_color, end=' ')
        for cell in result:
            print(cell[0], cell[1], end=' ')

        break

