#include <iostream>
#include <map>
#include <vector>

using Task = std::pair<std::string, std::string>;

bool are_similar(const Task& a, const Task& b) {
	return a.first == b.first || a.second == b.second;
}

int main() {
	int t;
	std::cin >> t;
	for (int _ = 0; _ != t; ++_) {
		int n;
		std::cin >> n;
		std::map<std::string, int> ss1, ss2;
		std::vector<Task> inp(n);
		for (int i = 0; i != n; ++i) {
			std::cin >> inp[i].first >> inp[i].second;
			ss1[inp[i].first] += 1;
			ss2[inp[i].second] += 1;
		}
		--ss1[inp[0].first];
		--ss2[inp[0].second];
		bool bad = false;

		for (int i = 1; i < n; ++i) {
			const auto& p = inp[i - 1];
			const auto& c = inp[i];
			if (ss1[p.first] > 0 || ss2[p.second] > 0) {
				if (!are_similar(p, c)) {
					bad = true;
					break;
				}
			}
			ss1[c.first]--;
			ss2[c.second]--;
		}

		if (bad) {
			std::cout << "No\n";
		} else {
			std::cout << "Yes\n";
		}
	}
}
