﻿using System;
using System.Linq;
using System.Numerics;
using System.Drawing;
using System.Collections;
using System.Collections.Generic;
using System.Collections.Specialized;

namespace Olymp
{
    class Program
    {
        const int Limit = 4000;

        static void Main(string[] args)
        {
            List<(int, int)> its = new List<(int, int)>();
            var (st, su, tu) = GetThree();
            its.Add(((int)st, 0)); // st
            its.Add(((int)su, 1)); // su
            its.Add(((int)tu, 2)); // tu

            if (its.Count(x => x.Item1 == 0) == 2 || its.Count(z => z.Item1 == 0) == 1 && its.Select(y => y.Item1).Where(w => w != 0).Distinct().Count() > 1)
            {
                Print("No");
                return;
            }

            its.Sort();
            int a = its[0].Item1,
                b = its[1].Item1,
                c = its[2].Item1;
            string s = new string('a', Limit);
            string t = new string('b', a) + new string('a', Limit - a);
            string u = new string('a', c - b) + new string('c', b) + new string('a', Limit - c);

            Print("Yes");
            if (Match(its[0].Item2, its[1].Item2, its[2].Item2, 0, 1, 2))
            {
                Print(s);
                Print(t);
                Print(u);
            }
            if (Match(its[0].Item2, its[1].Item2, its[2].Item2, 0, 2, 1))
            {
                Print(t);
                Print(s);
                Print(u);
            }
            if (Match(its[0].Item2, its[1].Item2, its[2].Item2, 1, 0, 2))
            {
                Print(s);
                Print(u);
                Print(t);
            }
            if (Match(its[0].Item2, its[1].Item2, its[2].Item2, 1, 2, 0))
            {
                Print(u);
                Print(s);
                Print(t);
            }
            if (Match(its[0].Item2, its[1].Item2, its[2].Item2, 2, 0, 1))
            {
                Print(t);
                Print(u);
                Print(s);
            }
            if (Match(its[0].Item2, its[1].Item2, its[2].Item2, 2, 1, 0))
            {
                Print(u);
                Print(t);
                Print(s);
            }
        }
        
        static bool Match(int x, int y, int z, int a, int b, int c)
        {
            return x == a && y == b && z == c;
        }


        #region InputHelpers
        static string Input() => Console.ReadLine();
        static long GetOne() => long.Parse(Console.ReadLine());
        static (long, long) GetTwo()
        {
            string[] parts = Console.ReadLine().Split();
            return (long.Parse(parts[0]), long.Parse(parts[1]));
        }
        static (long, long, long) GetThree()
        {
            string[] parts = Console.ReadLine().Split();
            return (long.Parse(parts[0]), long.Parse(parts[1]), long.Parse(parts[2]));
        }
        static long[] GetN() => Array.ConvertAll(Console.ReadLine().Split(), long.Parse);
        static T Print<T>(T arg)
        {
            Console.WriteLine(arg);
            return arg;
        }
        #endregion
    }
}
