﻿using System;
using System.Linq;
using System.Numerics;
using System.Drawing;
using System.Collections;
using System.Collections.Generic;
using System.Collections.Specialized;

namespace Olymp
{
    class Program
    {
        static void Main(string[] args)
        {
            string[] parts = Console.ReadLine().Split();

            string a = parts[0], b = parts[1];

            BigInteger s = BigInteger.Parse(parts[0]),
                       c = BigInteger.Parse(parts[1]);
            int digits = parts[0].Length;

            BigInteger[] cMul = new BigInteger[10];
            for (int i = 1; i < 10; i++)
                cMul[i] = c * i;

            int[][] lastIndices = new int[digits][];
            lastIndices[0] = new int[10];
            int[] cur = new int[10];
            for (int i = 0; i < 10; i++)
                cur[i] = -1;
            for (int i = 0; i < digits; i++)
            {
                lastIndices[i] = new int[10];
                for (int j = 0; j < 10; j++)
                {
                    lastIndices[i][j] = cur[j];
                }
                cur[a[i] - '0'] = i;
            }

            ReadOnlySpan<char> sp = a.AsSpan();

            List<int> collected = new List<int>();

            BigInteger last = 0;
            BigInteger exp = 1;
            int right = digits - 1;
            int left = digits - 1;
            int begin = 0;
            int index = 0;
            while (left > 0)
            {
                int lastDigit;
                if (index < collected.Count)
                {
                    lastDigit = collected[index];
                }
                else
                {
                    var m = cMul[a[right] - '0'];
                    last += m * exp;
                    exp *= 10;
                    lastDigit = (int)(last % exp / (exp / 10));
                    collected.Add(lastDigit);
                    right--;

                    if (right == begin)
                    {
                        if (last.ToString() == sp.Slice(0, right + 1))
                            break;
                    }
                }

                int newIndex = lastIndices[left][lastDigit];
                if (index == 0)
                {
                    begin = left = newIndex;
                    index++;
                }
                else if (newIndex == left - 1)
                {
                    left = newIndex;
                    index++;
                }
                else
                {
                    index = 0;
                }
            }

            string p1 = a.Substring(0, right + 1);
            string p2 = a.Substring(right + 1);
            Print(p1 + " " + p2);
        }

        #region InputHelpers
        static string Input() => Console.ReadLine();
        static long GetOne() => long.Parse(Console.ReadLine());
        static (long, long) GetTwo()
        {
            string[] parts = Console.ReadLine().Split();
            return (long.Parse(parts[0]), long.Parse(parts[1]));
        }
        static (long, long, long) GetThree()
        {
            string[] parts = Console.ReadLine().Split();
            return (long.Parse(parts[0]), long.Parse(parts[1]), long.Parse(parts[2]));
        }
        static long[] GetN() => Array.ConvertAll(Console.ReadLine().Split(), long.Parse);
        static T Print<T>(T arg)
        {
            Console.WriteLine(arg);
            return arg;
        }
        #endregion
    }
}
